// player.h: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
#if defined(_WINDOWS)
#define ADDRESS DWORD
#else
#define SOCKET int
#define ADDRESS in_addr_t
// 3 Includes fr sockaddr_in
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif
#include "math.h"
#include <vector>
#include <set>

//#define USER_CONTROL
//#define PRINT_DEBUG_INFO

inline void assert(bool b)
{
	if(b)
		return;
	printf("Assertion fehlgeschlagen!\n");
	while(true)
		;
	MessageBox(0, "Assertion fehlgeschlagen..", "Asteroids KI", 0);
}

static const int MAX_ASTEROIDS = 100;
static const int MAX_SHOTS = 10;
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;
const int MaxInt = 0x7FFFFFFF;

//#pragma warning( disable: 4309)

class Asteroid
{
public:
	int x;    // Koordinaten des Mittelpunkts
	int y;
	int type; // 1 ... 4, uere Form
	int sf;   // scale factor: 0 = gro, 15 = mittel, 14 = klein

	void set(int x, int y, int type, int sf);
};

class Shot
{
public:
	int x;
	int y;

	void set(int x, int y);
};

class GameStatus
{
public:
	bool ship_present;  // Schiff sichtbar
	int ship_x;         // Mittelpunkt des Schiffs
	int ship_y;
	int ship_dx;        // Blickrichtung des Schiffes
	int ship_dy;
	bool saucer_present;// UFO sichtbar
	int saucer_x;       // Mittelpunkt des UFOs
	int saucer_y;
	int saucer_size;    // Gre: 15 = gro, 14 = klein
	int nasteroids; // Anzahl Asteroiden
	Asteroid asteroids[MAX_ASTEROIDS];
	int nshots;     // Anzahl Schsse
	Shot shots[MAX_SHOTS];
	void clear(void);
};

enum Direction
{
	Dir_Left,
	Dir_None,
	Dir_Right
};

#pragma pack(1)

class KeysPacket
{
private:
	char signature[6];
public:
	static const char KEY_HYPERSPACE = 1;
	static const char KEY_FIRE = 2;
	static const char KEY_THRUST = 4;
	static const char KEY_RIGHT = 8;
	static const char KEY_LEFT = 0x10;

	char keys;
	char ping;     // wird vom Server bei nchster Gelegenheit zurckgeschickt. Fr Latenzmessung.

	KeysPacket(void);
	void clear(void);         // alle Tasten loslassen
	void hyperspace(bool b);  // Hyperspace drcken (true) oder loslassen (false)
	void fire(bool b);        // Feuerknopf drcken (true) oder loslassen (false)
	void thrust(bool b);      // Beschleunigen ...
	void right(bool b);       // rechts drehen ...
	void left(bool b);        // links drehen
	void SwapDirection()
	{
		if(keys & KEY_LEFT)
		{
			assert((keys&KEY_RIGHT) == 0);
			left(false);
			right(true);
		}
		else if(keys&KEY_RIGHT)
		{
			assert((keys&KEY_LEFT) == 0);
			left(true);
			right(false);
		}
	}
	void FromDirection(Direction Dir)
	{
		left(Dir == Dir_Left);
		right(Dir == Dir_Right);
	}
};


#if 0
enum RAM_Type
{
/*0x18*/	RAM_CurrentPlayer,
/*0x1C*/	RAM_NumPlayers,
/*0x52*/	RAM_PlayerScoreTens,
/*0x53*/	RAM_PlayerScoreThousends,
/*0x57*/	RAM_cShips,
/*0x59*/	RAM_HyperSpaceStatus,
/*0x5C*/	RAM_FastTimer,
/*0x5D*/	RAM_SlowTimer,
/*0x5F*/	RAM_RandomSeed1,
/*0x60*/	RAM_RandomSeed2,
/*0x61*/	RAM_ShipDirection,
/*0x63*/	RAM_FireHyperspaceToggle,
/*0x64*/	RAM_AccX,
/*0x65*/	RAM_AccY,
/*0x02F5*/	RAM_NumAsteroidsStart,
/*0x02F6*/	RAM_NumAsteroids,
/*0x02F7*/	RAM_SaucerCountdown,
/*0x02F8*/	RAM_SaucerCountdownStart,
/*0x02FA*/	RAM_InvisibleTimer,
/*0x02FB*/	RAM_NewLevelStartCountdown,
///*0x02FC*/	RAM_2FC,
///*0x02FD*/	RAM_2FD,
			RAM_Count
};
const int ByteAddress[RAM_Count] = 
{
	0x18,
	0x1C,
	0x52,
	0x53,
	0x57,
	0x59,
	0x5C,
	0x5D,
	0x5F,
	0x60,
	0x61,
	0x63,
	0x64,
	0x65,
	0x02F5,
	0x02F6,
	0x02F7,
	0x02F8,
	0x02FA,
	0x02FB,
//	0x02FC,
//	0x02FD,
};

enum RAMO_Type
{
/*0x200*/	RAMO_Status,
/*0x223*/	RAMO_VelocityX,
/*0x246*/	RAMO_VelocityY,
/*0x269*/	RAMO_PositionX,
/*0x28C*/	RAMO_PositionY,
/*0x2AF*/	RAMO_PositionExactX,
/*0x2D2*/	RAMO_PositionExactY,
			RAMO_Count
};

const int RAMO_Address[RAMO_Count] =
{
	0x200,
	0x223,
	0x246,
	0x269,
	0x28C,
	0x2AF,
	0x2D2,
};
#endif

const int cAsteroids = 27;
const int cPlayerShots = 4;
const int cSaucerShots = 2;

enum
{
	AsteroidMinIndex,
	AsteroidMaxIndex = AsteroidMinIndex+cAsteroids-1,
	PlayerIndex,
	SaucerIndex,
	SaucerShotMinIndex,
	SaucerShotMaxIndex = SaucerShotMinIndex+cSaucerShots-1,
	PlayerShotMinIndex,
	PlayerShotMaxIndex = PlayerShotMinIndex+cPlayerShots-1,
	NumObjects
};

const int ShotLifetime = 0x12 * 4;
const int RotationSpeed = 3;

inline bool MoveLinearXSingle(word& PositionX, char VelocityX)
{
	PositionX += VelocityX;
	if(PositionX >= 0x2000)//Objekt geht rechts oder links raus
	{
		PositionX &= 0x1FFF;//andere Seite wieder rein
		return true;
	}
	return false;
}

inline word MoveLinearX(word PositionX, char VelocityX, int Steps)
{
	return (PositionX + VelocityX*Steps) & 0x1FFF;
/*	word oldPositionX = PositionX;
	for(int i = 0; i < Steps; i++)
	{
		PositionX += char(VelocityX);
		if(PositionX >= 0x2000)//Objekt geht rechts raus
		{
			PositionX &= 0x1FFF;//links wieder rein
		}
	}
	if(PositionX != ((oldPositionX+char(VelocityX)*Steps)&0x1FFF))
		assert(0);
	return PositionX;*/
}

inline word MoveLinearY(word PositionY, char VelocityY, int Steps)
{
	PositionY += VelocityY*Steps;
	if(VelocityY >= 0)
	{
		while(PositionY >= 0x1800)
			PositionY -= 0x1800;
	}
	else
		while(PositionY >= 0x1800)
			PositionY += 0x1800;
	return PositionY;
/*	word oldPositionY = PositionY;
	word realoldPositionY = PositionY;
	for(int i = 0; i < Steps; i++)
	{
		PositionY += char(VelocityY);
		if(PositionY>>8 == 0x0018)//Objekt geht unten raus
		{
			PositionY = 0x0000 | (PositionY&0x00FF);
		}
		else if(PositionY >= 0x1800)
		{
			PositionY = 0x1700 | (PositionY&0x00FF);
		}
	}
	if(PositionY != oldPositionY)
		assert(0);
	return PositionY;*/
}
struct ShotInfo
{
public:
	ShotInfo()
	{
		Time = MaxInt;
	}
public:
	int Time;
	Direction Dir;
	byte TargetDirection;
	int CollisionTime;

	int ShotIndex;
	word PositionX, PositionY;
	int Target;
	word StartX, StartY;
	char VelocityX, VelocityY;
	word TargetPositionX, TargetPositionY;
	char TargetStatus;
};

/*struct DirInfo
{
	word StartX, StartY;
	char VelocityX, VelocityY;
	int CollisionAtTime;
	int ShotTime;

	int PositionX(int t)
	{
		return MoveLinearX(StartX, VelocityX, t);
	}
	int PositionY(int t)
	{
		return MoveLinearY(StartY, VelocityY, t);
	}
	int PositionXEasy(int t)
	{
		return int(StartX)+int(VelocityX)*t;
	}
	int PositionYEasy(int t)
	{
		return int(StartY)+int(VelocityY)*t;
	}
};*/
//extern bool* pErrorsOccured;
extern bool updating;
extern __int64* pScore;
//extern std::vector<ShotInfo> ShotInfos;

inline word MakeWord(byte high, byte low)
{
	return word(high)<<8 | word(low);
}
inline void MakeBytesFromWord(word Word, byte& High, byte& Low)
{
	High = byte(Word>>8);
	Low = byte(Word);
}
inline byte& LowByte(word& Word)
{
	return (byte&)Word;
}
inline byte& HighByte(word& Word)
{
	return *(((byte*)&Word)+1);
}
inline byte Half(byte value)
{
	if(char(value) >= 0)
		return value/2;
	else
		return char(value-1)/2;
}
inline void Clamp(byte& value, byte min, byte max)
{
	if(char(value) >= 0)
	{
		if(value > max)
			value = max;
	}
	else
	{
		if(value < min)
			value = min;
	}
}
template<typename T>
T Min(T a, T b)
{
	return a<b ? a : b;
}
template<typename T>
T Max(T a, T b)
{
	return a>b ? a : b;
}
inline word DecimalToBin(byte High, byte Low)
{
	return (High>>4)*1000 + (High&0x0F)*100 + (Low>>4)*10 + (Low&0x0F);
}
inline void BinToDecimal(word Bin, byte& High, byte& Low)
{
	Low = Bin%10;
	Bin /= 10;
	Low |= Bin%10 << 4;
	Bin /= 10;
	High = Bin%10;
	Bin /= 10;
	High |= Bin%10 << 4;
}
inline byte& ShiftLeft(byte& byte, bool& carry)
{
	carry = (byte>>7) != 0;
	byte <<= 1;
	return byte;
}
inline byte& RotateLeft(byte& byte, bool& carry)
{
	bool newcarry = (byte>>7) != 0;
	byte <<= 1;
	if(carry) byte |= 1;
	carry = newcarry;
	return byte;
}
inline byte& ShiftRight(byte& byte, bool& carry)
{
	carry = (byte&1) != 0;
	byte >>= 1;
	return byte;
}
inline byte& RotateRight(byte& byte, bool& carry)
{
	bool newcarry = (byte&1) != 0;
	byte >>= 1;
	if(carry) byte |= 0x80;
	carry = newcarry;
	return byte;
}
inline byte& Add(byte& a, byte b, bool& carry)
{
	int sum = a + int(b) + (carry ? 1 : 0);
	carry = (sum & 0xFF00) != 0;
	a = (byte)sum;
	return a;
}
inline byte& Subtract(byte& a, byte b, bool& carry)
{
	int c = (carry ? 1 : 0) ^ 1;
	int dif = a - int(b) - c;
	carry = (dif & 0xff00) == 0;
	a = (byte)dif;
	return a;
}

class Object
{
public:
	char Status; //Negativ: Objekt explodiert gerade.
	             //0: Objekt nicht vorhanden.
                 //Positiv: Je nach Objekttyp. Bei...
	             //                            Asteroiden: Gre und Anzeigetyp
	             //                            Spieler: immer 1
				 //							   UFO: 2 (gro) oder 1 (klein)
	             //                            Schsse: ein herunterlaufender Timer
	word PositionX, PositionY;
	char VelocityX, VelocityY;
};
class ShotInfoList;
class GameRam
{
public:
	int CurrentTime;
private:
	byte CurrentPlayer;         
	byte NumPlayers;
	byte PlayerScoreTens, PlayerScoreThousends;	
	byte cShips;				
	char HyperSpaceStatus;		
	byte FastTimer, SlowTimer;				
public:
	byte RandomSeed1, RandomSeed2;			
private:
	byte ShipDirection;			
	byte FireHyperspaceToggle; //Hier wird gespeichert, ob im letzten Frame geschossen wurde
	byte AccX, AccY; //Acc steht fr Acceleration. Die Variablen zeigen aber nicht wirklich
					 //die Beschleunigung, sondern stellen einen Timer fr jede Komponente dar.
	                 //Bei jedem Durchlauf wird die Geschwindigkeit gendert, je nachdem, ob
	                 //man gerade Gas gibt oder nicht.
	                 //Habs einfach so genannt, weil ich beim Lesen des Maschinencodes noch
	                 //nicht wusste, was sie genau bedeuten..
	byte NumAsteroids, NumAsteroidsStart;
	byte SaucerCountdown, SaucerCountdownStart;	
	byte _2F9;
	byte InvisibleTimer;		
	byte NewLevelStartCountdown;
	byte _2FD;

	ShotInfo ShotInfosCheck[cPlayerShots];

public:
	Object Objects[NumObjects];
public:
	void StartNewGame()//loc_68DE
	{
		memset(this, 0, sizeof(*this));//An alle Zuschauer zu Hause: Bitte nicht nachmachen!
		NumPlayers = 1;
		cShips = 3;
		RandomSeed1 = 3;
		NumAsteroidsStart = 2;
		InvisibleTimer = 1;
		SaucerCountdownStart = SaucerCountdown = 0x92;
		NewLevelStartCountdown = 0x7F;
		_2FD = 5;
		ResetPlayerPosition();
		for(int i = 0; i < cPlayerShots; i++)
			ShotInfosCheck[i] = ShotInfo();
	}
	const Object* GetObjects() const
	{
		return Objects;
	}
	void CalculateNextShot(const ShotInfoList& ShotInfos, int MinShootTime, std::multiset<ShotInfoList>& ShotInfosVariety);
//	void CalculateNextShot(std::vector<ShotInfo>& ShotInfos, int& MaxCollisionTime, int MinShootTime);
	void CheckForErrors(const ShotInfoList& ShotInfos, int UntilTime);

	int GetCountExtraSlots() const
	{
		int CountExtraSlots = 0;
		for(int i = PlayerShotMinIndex; i <= PlayerShotMaxIndex; i++)
			if(Objects[i].Status == 0)
				CountExtraSlots++;
		return CountExtraSlots;
	}

	void Render(HDC hdcScreen, int cx, int cy);
	bool Check(const byte* ram, const KeysPacket& keys, const ShotInfo& ShotInfo, bool set)
	{
/*		byte s1 = Var(RAM_RandomSeed1);
		byte s2 = Var(RAM_RandomSeed2);
		Rand();
		int i = 0;
		while(s1 != Var(RAM_RandomSeed1) || s2 != Var(RAM_RandomSeed2))
		{
			printf("%i: %x%x\n", ++i, Var(RAM_RandomSeed1), Var(RAM_RandomSeed2));
			Rand();
		}
		while(true);*/

		struct
		{
			byte* pVariable;
			int Address;
		}
		VariableAddresses[] =
		{
			&CurrentPlayer,            0x18,
			&NumPlayers,			   0x1C,
			&PlayerScoreTens,		   0x52,
			&PlayerScoreThousends,	   0x53,
			&cShips,				   0x57,
			(byte*)&HyperSpaceStatus,  0x59,
			&FastTimer,				   0x5C,
			&SlowTimer,				   0x5D,
			&RandomSeed1,			   0x5F,
			&RandomSeed2,			   0x60,
			&ShipDirection,			   0x61,
			&FireHyperspaceToggle,	   0x63,
			&AccX,					   0x64,
			&AccY,					   0x65,
			&NumAsteroidsStart,        0x02F5,
			&NumAsteroids,			   0x02F6,
			&SaucerCountdown,		   0x02F7,
			&SaucerCountdownStart,	   0x02F8,
			&_2F9,					   0x02F9,
			&InvisibleTimer,		   0x02FA,
			&NewLevelStartCountdown,   0x02FB,
			&_2FD,                     0x02FD
		};

		if(set)
		{
			for(int i = 0; i < _countof(VariableAddresses); i++)
				*VariableAddresses[i].pVariable = ram[VariableAddresses[i].Address];
			for(int i = 0; i < NumObjects; i++)
			{
				Objects[i].Status = char(ram[0x200+i]);
				Objects[i].VelocityX = char(ram[0x223+i]);
				Objects[i].VelocityY = char(ram[0x246+i]);
				Objects[i].PositionX = MakeWord(ram[0x269+i], ram[0x2AF+i]);
				Objects[i].PositionY = MakeWord(ram[0x28C+i], ram[0x2D2+i]);
			}
			return false;
		}

	
		bool errors = false;
		for(int i = 0; i < _countof(VariableAddresses); i++)
			if(//i!=RAM_RandomSeed1 && i!=RAM_RandomSeed2 &&
				//i!=RAM_FireHyperspaceToggle &&
				VariableAddresses[i].pVariable!=&cShips &&
				//i!=RAM_PlayerScoreTens && i!=RAM_PlayerScoreThousends &&
				//VariableAddresses[i].pVariable!=&SaucerCountdown && VariableAddresses[i].pVariable!=&SaucerCountdownStart &&
				//i!=RAM_PositionExactX && i!=RAM_PositionExactY &&
				//i!=RAM_PositionX && i!=RAM_PositionY &&
				//i!=RAM_VelocityY && i!=RAM_AccY &&
				*VariableAddresses[i].pVariable != ram[VariableAddresses[i].Address])
			{
				printf("Byte an Adresse %x verschieden: berechnet: %x tatschlich %x\n", VariableAddresses[i].Address, *VariableAddresses[i].pVariable, ram[VariableAddresses[i].Address]);
				errors = true;
			}

		for(int i = 0; i < NumObjects; i++)
		{
			if( Objects[i].Status != char(ram[0x200+i]) ||
				Objects[i].VelocityX != char(ram[0x223+i]) ||
				Objects[i].VelocityY != char(ram[0x246+i]) ||
				Objects[i].PositionX != MakeWord(ram[0x269+i], ram[0x2AF+i]) ||
				Objects[i].PositionY != MakeWord(ram[0x28C+i], ram[0x2D2+i]))
			{
				printf("Byte bei Obj %x an Adresse %x verschieden: berechnet: %x tatschlich %x\n",
					i, 0,0,0/*RAMO_Address[j], ram[RAMO_Address[j]+i], ram2[RAMO_Address[j]+i]*/);
				errors = true;
			}
		}

		while(errors)
		{
			*this = last_ram;
			Move_(keys, ShotInfo);
		}


		return errors;
	}
	static GameRam last_ram;
	void Move(const ShotInfo& CurrentShotInfo, const ShotInfo& NextShotInfo)
	{
		KeysPacket keys;
#ifdef USER_CONTROL
		if(GetAsyncKeyState('Q') < 0)
			keys.left(true);
		if(GetAsyncKeyState('W') < 0)
			keys.right(true);
		if(GetAsyncKeyState('I') < 0)
			keys.thrust(true);
		if(GetAsyncKeyState('O') < 0)
			keys.fire(true);
		if(GetAsyncKeyState(VK_SPACE) < 0)
			keys.hyperspace(true);
#else
		assert(CurrentShotInfo.Time >= CurrentTime);
		if(ShipDirection != CurrentShotInfo.TargetDirection)
			keys.FromDirection(CurrentShotInfo.Dir);
		if(CurrentShotInfo.Time == CurrentTime)
		{
			assert(ShipDirection == CurrentShotInfo.TargetDirection);
			assert(NextShotInfo.Time > CurrentTime);
			keys.fire(true);
			if(ShipDirection != NextShotInfo.TargetDirection)
				keys.FromDirection(NextShotInfo.Dir);
			else
				keys.FromDirection(Dir_None);
		}
#endif
		Move_(keys, CurrentShotInfo);
	}
	void Move_(const KeysPacket& keys, const ShotInfo& ShotInfo)
	{
		last_ram = *this;
		
		if(++FastTimer == 0)
			SlowTimer++;

		//sub_6885
		if(NumPlayers &&
			Objects[PlayerIndex].Status==0 &&
			InvisibleTimer == 0x80)
		{
			InvisibleTimer = 0x10;
		}

		Shoot(keys, ShotInfo);
		DoHyperSpace(keys);
		UpdateHyperspace(keys); //Ruft UpdateDirectionAndThrust() auf
		UpdateSaucer();

		//Objekte aktualisieren
		for(int i = NumObjects-1; i >= 0; i--)
			MoveObject(i);

		// Kollision fr Spielerschsse(4), Saucerschsse(2), Saucer und Schiff prfen
		for(int i = PlayerShotMaxIndex; i >= PlayerIndex; i--)
			CheckCollisions(i);

		Rand();

		//sub_7BC0

		byte a = NewLevelStartCountdown;
		if(a)
			NewLevelStartCountdown--;
		if((a | NumAsteroids) == 0)
			ResetAsteroids();
		CurrentTime++;
	}
/*	byte Hash()
	{
		byte h = 0;
		for(int i = 0x200; i < 0x2F4; i++)
			h += ram[i];
		h += ram[0x5F];
		h += ram[0x60];
		return h;
	}*/

	void Shoot(const KeysPacket& keys, const ShotInfo& ShotInfo)//sub_6CD7
	{
		if(NumPlayers == 0)
		{
			assert(ShotInfo.Time > CurrentTime);
			return;
		}
		FireHyperspaceToggle >>= 1;
		if(keys.keys & KeysPacket::KEY_FIRE)
			FireHyperspaceToggle |= 0x80;
		if(!(keys.keys & KeysPacket::KEY_FIRE))
		{
			assert(ShotInfo.Time > CurrentTime);
			return;
		}
		if(FireHyperspaceToggle & 0x40)//letzten Frame schon gedrckt?
		{
			assert(ShotInfo.Time > CurrentTime);
			return;
		}
		if(InvisibleTimer)
		{
			assert(ShotInfo.Time > CurrentTime);
			return;
		}

		int NewShot = PlayerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == PlayerShotMinIndex)
			{
				assert(ShotInfo.Time > CurrentTime);
				return;
			}
#ifndef USER_CONTROL
//		assert(ShotInfo.ShotIndex == NewShot);
		assert(ShotInfo.ShotIndex != -1);
		assert(ShotInfo.Time == CurrentTime);
		ShotInfosCheck[NewShot-PlayerShotMinIndex] = ShotInfo;
#endif

		Objects[NewShot] = Objects[PlayerIndex];
		Objects[NewShot].Status = ShotLifetime/4;

		ShootLocationFromAngle(ShipDirection, Objects[NewShot].PositionX, Objects[NewShot].PositionY, Objects[NewShot].VelocityX, Objects[NewShot].VelocityY);
#ifndef USER_CONTROL
		assert(ShotInfo.StartX == Objects[NewShot].PositionX);
		assert(ShotInfo.StartY == Objects[NewShot].PositionY);
		assert(ShotInfo.VelocityX == Objects[NewShot].VelocityX);
		assert(ShotInfo.VelocityY == Objects[NewShot].VelocityY);
#endif
	}

/*		//xVelocity
		byte a = Var(RAM_ShipDirection);
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += VarO(RAMO_VelocityX, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityX, PlayerIndex+NewShot) = a;

		//yVelocity
		a = Var(RAM_ShipDirection);
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += VarO(RAMO_VelocityY, PlayerIndex);
		Clamp(a, 0x91, 0x6F);
		VarO(RAMO_VelocityY, PlayerIndex+NewShot) = a;

		//xPosition
		a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, VarO(RAMO_PositionExactX, PlayerIndex), c);
		VarO(RAMO_PositionExactX, PlayerIndex+NewShot) = a;
		Add(tmp8, VarO(RAMO_PositionX, PlayerIndex), c);
		VarO(RAMO_PositionX, PlayerIndex+NewShot) = tmp8;

		//yPosition
		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, VarO(RAMO_PositionExactY, PlayerIndex), c);
		VarO(RAMO_PositionExactY, PlayerIndex+NewShot) = a;
		Add(tmpB, VarO(RAMO_PositionY, PlayerIndex), c);
		VarO(RAMO_PositionY, PlayerIndex+NewShot) = tmpB;*/
	static void ShootLocationFromAngle(byte Direction, word& PositionX, word& PositionY, char& VelocityX, char& VelocityY)
	{
		//xVelocity
		byte a = Direction;
		CosLookup(a);
		bool c = a >= 0x80;
		RotateRight(a, c);
		byte tmp9 = a;
		a += byte(VelocityX);
		Clamp(a, 0x91, 0x6F);
		VelocityX = char(a);

		//yVelocity
		a = Direction;
		SinLookup(a);
		c = a >= 0x80;
		RotateRight(a, c);
		byte tmpC = a;
		a += byte(VelocityY);
		Clamp(a, 0x91, 0x6F);
		VelocityY = char(a);

		//xPosition
		/*a = tmp9;
		byte tmp8 = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmp9;
		c = false;
		Add(a, LowByte(PositionX), c);
		LowByte(PositionX) = a;
		Add(tmp8, HighByte(PositionX), c);
		HighByte(PositionX) = tmp8;*/
		PositionX += char(tmp9) + char(Half(tmp9));

		//yPosition
/*		a = tmpC;
		byte tmpB = char(a)<0 ? 0xFF : 0;
		c = a >= 0x80;
		RotateRight(a, c);
		a += tmpC;
		c = false;
		Add(a, LowByte(PositionY), c);
		LowByte(PositionY) = a;
		Add(tmpB, HighByte(PositionY), c);
		HighByte(PositionY) = tmpB;*/
		PositionY += char(tmpC) + char(Half(tmpC));

	}

	void DoHyperSpace(const KeysPacket& keys)//sub_6E74
	{
		if(!(keys.keys & KeysPacket::KEY_HYPERSPACE) ||
			NumPlayers == 0 ||
			InvisibleTimer ||
			Objects[PlayerIndex].Status < 0)
			return;

		Objects[PlayerIndex].Status = 0;
		Objects[PlayerIndex].VelocityX = 0;
		Objects[PlayerIndex].VelocityY = 0;
		InvisibleTimer = 0x30;

		byte a = Rand() & 0x1F;
		if(a >= 0x1D)
			a = 0x1C;
		if(a < 3)
			a = 3;
		HighByte(Objects[PlayerIndex].PositionX) = a;
	
		for(int i = 0; i < 4; i++)
			Rand();
		a = Rand() & 0x1F;
		HyperSpaceStatus = 1;
		if(a >= 0x18)
		{
			a &= 7;
			bool c;
			ShiftLeft(a, c);
			Add(a, 4, c);
			if(a >= NumAsteroids)//HyperSpace fehlgeschlagen
				HyperSpaceStatus = -128;
		}
		Clamp(a, 3, 0x14);
		HighByte(Objects[PlayerIndex].PositionY) = a;
	}

	void UpdateHyperspace(const KeysPacket& keys)//sub_703F
	{
		if(NumPlayers == 0 ||
			Objects[PlayerIndex].Status < 0)
			return;
		if(InvisibleTimer == 0)
		{
			UpdateDirectionAndThrust(keys);
			return;
		}
		if(--InvisibleTimer)
			return;
		if(char(HyperSpaceStatus) < 0) goto loc_706F;
		if(HyperSpaceStatus) goto loc_7068;
		if(!CanShipAppear()) goto loc_7081;
		if(Objects[SaucerIndex].Status)
		{
			InvisibleTimer = 2;
			return;
		}
loc_7068:
		Objects[PlayerIndex].Status = 1;
		goto loc_7081;
loc_706F:
		Objects[PlayerIndex].Status = -96;
		cShips--;
		InvisibleTimer = 0x81;
loc_7081:
		HyperSpaceStatus = 0;
	}

	bool CanShipAppear()
	{
		for(int i = SaucerIndex; i >= 0; i--)
		{
			if(Objects[i].Status == 0)
				continue;

			byte dif = HighByte(Objects[i].PositionX)-HighByte(Objects[PlayerIndex].PositionX);
			if(dif < 0xFC && dif >= 4)
				continue;

			dif = HighByte(Objects[i].PositionY)-HighByte(Objects[PlayerIndex].PositionY);
			if(dif < 0xFC && dif >= 4)
				continue;

			InvisibleTimer++;
			return false;
		}
		return true;
	}

	void UpdateDirectionAndThrust(const KeysPacket& keys)//loc_7086
	{
		if(keys.keys & KeysPacket::KEY_LEFT)
			ShipDirection += RotationSpeed;
		else if(keys.keys & KeysPacket::KEY_RIGHT)
			ShipDirection -= RotationSpeed;
		
		if(FastTimer & 1)
			return;
		if(keys.keys & KeysPacket::KEY_THRUST)
		{
			byte y = 0;
			byte a = ShipDirection;//a=0
			CosLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;   //a=80/FE
			bool c = false;
			Add(a, AccX, c);//a=f9  c=1
			byte x = a;//x=77
			a = y;
			Add(a, Objects[PlayerIndex].VelocityX, c);//a=2
			sub7125(a, x);
			Objects[PlayerIndex].VelocityX = a;
			AccX = x;

			y = 0;
			a = ShipDirection;
			SinLookup(a);
			if(char(a) < 0)
				y--;
			a <<= 1;
			c = false;
			Add(a, AccY, c);
			x = a;
			a = y;
			Add(a, Objects[PlayerIndex].VelocityY, c);
			sub7125(a, x);
			Objects[PlayerIndex].VelocityY = a;
			AccY = x;
		}
		else
		{
			// KEY_THRUST nicht gedrckt:
			if(Objects[PlayerIndex].VelocityX | AccX)
			{
				byte a = (Objects[PlayerIndex].VelocityX << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(a, AccX, c); // Wenn man beide Zeilen durch Add(AccX, a, c); ersetzt optimiert der Microsoft Compiler falsch...
				AccX = a;
				Add((byte&)Objects[PlayerIndex].VelocityX, x, c);
			}
			if(Objects[PlayerIndex].VelocityY | AccY)
			{
				byte a = (Objects[PlayerIndex].VelocityY << 1) ^ 0xFF;
				bool c = char(a) >= 0;
				byte x = c ? 0 : 0xFF;
				Add(a, AccY, c);
				AccY = a;
				Add((byte&)Objects[PlayerIndex].VelocityY, x, c);
			}
/*		
				char a = Var(RAM_VelocityY)<<1;
				char x = 0xFF;
				a ^= 0xFF;
				bool c = false;
				if(a >= 0)
				{
					x++;
					c = true;
				}
				int sum = int(a)+int(Var(RAM_AccY))+c;
				bool overflow = (sum & 0xFF00) != 0;
				a = sum;
				Var(RAM_AccY) = a;
				a = x;
				a += Var(RAM_VelocityY) + overflow;
				Var(RAM_VelocityY) = a;*/
		}
	}


	void MoveObject(int i)
	{
		//byte tmp4, tmp5, tmp6, tmp7;
		byte a = Objects[i].Status;
		if(a == 0)
			return;
		//loc_6F62
		if(char(a) < 0)
		{
			//Objekt explodiert
			a = ((a^0xFF)+1) >> 4;
//			a = (-a) >> 4;
			bool c = true;
			if(i == PlayerIndex)
			{
				c = (FastTimer&1) != 0;
				a = 0;
			}
			//loc_6F77
			Add(a, Objects[i].Status, c);
			if(char(a) < 0)
			{//loc_6FA1
				//Objekt explodiert weiter
				Objects[i].Status = a;
				//a = (a&0xF0)+0x10;
				//if(i == PlayerIndex)
				//	a = 0;
				//byte y = a;
				//4567a = VarO(RAMO_PositionExactX, i);
				{//loc_7027
					//sub_72FE
				}
			}
			else if(i == PlayerIndex)
			{//loc_6F93
				ResetPlayerPosition();
				Objects[i].Status = 0;
			}
			else if(i == SaucerIndex)
			{//loc_6F99
				SaucerCountdown = SaucerCountdownStart;
				Objects[i].Status = 0;
			}
			else
			{
				assert(i >= AsteroidMinIndex && i <= AsteroidMaxIndex);
				if(--NumAsteroids == 0)
					NewLevelStartCountdown = 0x7F;
				Objects[i].Status = 0;
			}
			return;
		}
		//loc_6FC7
//		byte y = 0;

		//xPosition += char(VarO(RAMO_VelocityX, i));
		/*a = VarO(RAMO_VelocityX, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactX, i), c);
		VarO(RAMO_PositionExactX, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionX, i), c);*/
//		if(a >= 0x20)//Objekt geht rechts raus
		if(MoveLinearXSingle(Objects[i].PositionX, Objects[i].VelocityX))
		{
			if(i == SaucerIndex)
			{
				//sub_702D
				SaucerCountdown = SaucerCountdownStart;
				Objects[SaucerIndex].Status = 0;
				Objects[SaucerIndex].VelocityX = 0;
				Objects[SaucerIndex].VelocityY = 0;
				return;
			}
		}
//		MakeBytesFromWord(xPosition, VarO(RAMO_PositionX, i), VarO(RAMO_PositionExactX, i));
		//loc_6FEC
		//VarO(RAMO_PositionX, i) = a;

		Objects[i].PositionY = MoveLinearY(Objects[i].PositionY, Objects[i].VelocityY, 1);
//		MakeBytesFromWord(yPosition, VarO(RAMO_PositionY, i), VarO(RAMO_PositionExactY, i));

/*		y = 0;
		a = VarO(RAMO_VelocityY, i);
		if(char(a) < 0)
			y--;
		bool c = false;
		Add(a, VarO(RAMO_PositionExactY, i), c);
		VarO(RAMO_PositionExactY, i) = a;
		a = y;
		Add(a, VarO(RAMO_PositionY, i), c);
		if(a >= 0x18)
		{
			if(a == 0x18)
			{//loc_7011
				a = 0;
			}
			else
				a = 0x17;
		}
		//loc_7013
		VarO(RAMO_PositionY, i) = a;*/

		/*a = Objects[i].Status;
		y = 0xE0;
		if((a&1) == 0)
		{
			y = 0xF0;
			if((a&2) == 0)
				y = 0;
		}*/
		sub_72FE(i);
	}

	void sub_72FE(int i)
	{
	/*	byte tmp0 = y;
		bool c = false;
		a = tmp5;
		ShiftRight(a, c);
		RollRight(tmp4, c);
		ShiftRight(a, c);
		RollRight(tmp4, c);
		ShiftRight(a, c);
		RollRight(tmp4, c);
		tmp5 = a;

		a = tmp7+4;
		c = false;
		ShiftRight(a, c);
		RollRight(tmp6, c);
		ShiftRight(a, c);
		RollRight(tmp6, c);
		ShiftRight(a, c);
		RollRight(tmp6, c);
		tmp7 = a;
		byte x = 4;
		//sub_7C1C
		a = 0x70;
		a -= tmp0;
		while(char(a) >= -96)
		{
			byte stack = a;
			a = 0x90;
			//sub_7CDE
			a = stack;
			a -= 0x10;
		}
		//loc_733B
		//sub_7CDE
		a = Objects[i].Status;
		if(char(a) >= 0)
		{//loc_735B
		}
		if(i != PlayerIndex)
		{
			y = (a&0x0C)>>1;
//				a = 50F8[y];
//				x = 50F9[y];
			if(x != 0)
			{
				//loc_7370
			}
		}
		{//sub_7465
			
		}*/
//loc_7384:
		//...
		if(i > SaucerIndex && (FastTimer & 3) == 0)
		{
			Objects[i].Status--;
			if(!updating && !Objects[i].Status && i >= PlayerShotMinIndex)
			{//////////
#ifdef PRINT_DEBUG_INFO
				printf("Shot %i ins Leere gegangen um %i\n", i-PlayerShotMinIndex, CurrentTime);
#endif
				//*pErrorsOccured = true;
			}
		}
	}

	void ResetAsteroids();


	void ResetPlayerPosition()//sub_71E8
	{
		Objects[PlayerIndex].PositionX = 0x1060;
		Objects[PlayerIndex].PositionY = 0x0C60;

		Objects[PlayerIndex].VelocityX = 0;
		Objects[PlayerIndex].VelocityY = 0;
	}

	static void CosLookup(byte& a)//sub_77D2
	{
		a += 0x40;
		SinLookup(a);
	}

	static void SinLookup(byte& a)//sub_77D5
	{
		const byte Table[0x41] =//0x57B9
		{
			0x00, 0x03, 0x06, 0x09, 0x0c, 0x10, 0x13, 0x16, 0x19, 0x1c, 0x1f, 0x22, 0x25, 0x28,
			0x2b, 0x2e, 0x31, 0x33, 0x36, 0x39, 0x3c, 0x3f, 0x41, 0x44, 0x47, 0x49, 0x4c, 0x4e,
			0x51, 0x53, 0x55, 0x58, 0x5a, 0x5c, 0x5e, 0x60, 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6b,
			0x6d, 0x6f, 0x70, 0x71, 0x73, 0x74, 0x75, 0x76, 0x78, 0x79, 0x7a, 0x7a, 0x7b, 0x7c,
			0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7f, 0x7f, 0x7f, 0x7f
		};
		bool inv = false;
		if(char(a) < 0)
		{
			inv = true;
			a &= 0x7F;
		}
		if(a >= 0x41)
			a = (a^0x7F) + 1;
		a = Table[a];
		if(inv)
			a = (a^0xFF) + 1;
	}

	void sub7125(byte& a, byte& x)
	{
		if(char(a) >= 0)
		{
			if(a >= 0x40)
			{
				x = 0xFF;
				a = 0x3F;
			}
		}
		else
		{
			if(a < 0xC0)
			{
				x = 1;
				a = 0xC0;
			}
		}
	}

	void CloneAsteroid(byte Dest, byte Src)//sub_6A9D
	{
		Objects[Dest] = Objects[Src];
		Objects[Dest].Status = (Objects[Src].Status&7) | (Rand()&0x18);
	}

	void SplitAsteroid(byte CollisionCauser, byte Asteroid)//Erzeugt zwei kleine Asteroiden
	{//sub_75EC
		//byte a = Objects[y].Status;
		//a &= 0x78;
		//byte tmp_e = a;
		byte NewStatus = (Objects[Asteroid].Status&7) >> 1;
		if(NumPlayers && (CollisionCauser == PlayerIndex || CollisionCauser >= PlayerShotMinIndex))
		{
			//Der Schuss ist vom Spieler oder der Spieler kollidiert selber mit dem Asteroid
			if(NewStatus == 0)
				AddScore(10);
			else if(NewStatus == 1)
				AddScore(5);
			else if(NewStatus == 2)
				AddScore(2);
			else
				assert(0);
		}
		if(NewStatus)
			Objects[Asteroid].Status = (NewStatus | (Objects[Asteroid].Status&0x78));
		else
		{
			Objects[Asteroid].Status = 0;
			return;
		}
		byte NewAsteroid = NextAsteroidSlot(PlayerIndex-1);
		if(NewAsteroid == 0xFF)
		{//////////
			//MessageBeep(0);
#ifdef PRINT_DEBUG_INFO
			printf("Keine Slots mehr uebrig!!\n");
#endif
			return;
		}
		NumAsteroids++;
		CloneAsteroid(NewAsteroid, Asteroid);
		sub_7203(NewAsteroid, Asteroid);
		LowByte(Objects[NewAsteroid].PositionX) ^= (Objects[NewAsteroid].VelocityX&0x1F) << 1;
		NewAsteroid = NextAsteroidSlot(NewAsteroid-1);
		if(NewAsteroid == 0xFF)
		{
			//MessageBeep(0);
#ifdef PRINT_DEBUG_INFO
			printf("Nur noch ein Slot uebrig bei Asteroid %x um %i!!\n", Asteroid, CurrentTime);
#endif
			return;
		}
		NumAsteroids++;
		CloneAsteroid(NewAsteroid, Asteroid);
		sub_7203(NewAsteroid, Asteroid);
		LowByte(Objects[NewAsteroid].PositionY) ^= (Objects[NewAsteroid].VelocityY&0x1F) << 1;
	}

	byte NextAsteroidSlot(byte StartSearchAt)
	{//sub_745A
		byte i = StartSearchAt;
		while(i!=0xFF && Objects[i].Status)
			i--;
		return i;
	}

	void sub_7203(byte& x, byte& y)
	{
		byte a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		a += Objects[y].VelocityX;
		sub_7233(a);
		Objects[x].VelocityX = a;
	
		Rand(); Rand(); Rand();

		a = Rand() & 0x8F;
		if(char(a) < 0)
			a |= 0xF0;
		a += Objects[y].VelocityY;
		sub_7233(a);
		Objects[x].VelocityY = a;
	}

	void sub_7233(byte& a)
	{
		if(char(a) < 0)
		{
			if(a < 0xE1)
				a = 0xE1;
			else if(a >= 0xFB)
				a = 0xFA;
		}
		else
		{
			if(a < 6)
				a = 6;
			else if(a >= 0x20)
				a = 0x1F;
		}
	}

	void AddScore(byte ToAdd)
	{//sub_7397
		word Score = DecimalToBin(PlayerScoreThousends, PlayerScoreTens);
		if(Score/1000 != (Score+ToAdd)/1000)
			cShips++;
		Score += ToAdd;
		if(pScore)
			*pScore += ToAdd;
		BinToDecimal(Score, PlayerScoreThousends, PlayerScoreTens);
	}
	void CheckCollisions(byte CollisionCauser);

	static bool AreObjectsNear(byte i, word iPositionX, word iPositionY, byte iStatus,
							   byte j, word jPositionX, word jPositionY, byte jStatus)
	{//Ship/Saucer/Shots mssen in i sein, Asteroiden in j
		byte a = LowByte(jPositionX);
		bool c = true;
		Subtract(a, LowByte(iPositionX), c);
		byte tmp8 = a;
		a = HighByte(jPositionX);
		Subtract(a, HighByte(iPositionX), c);
		ShiftRight(a, c);
		RotateRight(tmp8, c);
		ShiftLeft(a, c);
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp8 ^= 0xFF;
		}
		a = LowByte(jPositionY);
		c = true;
		Subtract(a, LowByte(iPositionY), c);
		byte tmp9 = a;
		a = HighByte(jPositionY);
		Subtract(a, HighByte(iPositionY), c);
		ShiftRight(a, c);
		RotateRight(tmp9, c);
		ShiftLeft(a, c);
		if(a)
		{
			if(char(a) >= 0)
				return false;
			a ^= 0xFE;
			if(a)
				return false;
			tmp9 ^= 0xFF;
		}
		a = 0x2A;
		ShiftRight(jStatus, c);
		if(!c)
		{
			a = 0x48;
			ShiftRight(jStatus, c);
			if(!c)
				a = 0x84;
		}
		if(i == PlayerIndex)
			a += 0x1C;
		else if(i == SaucerIndex)
		{
			c = true;
			Add(a, 0x12, c);
			if(iStatus != 1)
				Add(a, 0x12, c);
		}
		if(a < tmp8) return false;
		if(a < tmp9) return false;
		byte tmp = a;
		a >>= 1;
		c = false;
		Add(a, tmp, c);
		tmp = a;
		a = tmp9;
		Add(a, tmp8, c);
		if(c) return false;
		if(a >= tmp) return false;
		return true;
	}

	// Gibt zurck, ob sich die Asteroiden oder das UFO gendert haben
	bool OnCollision(byte CollisionCauser, byte& y)//sub_6B0F
	{
		if(CollisionCauser != SaucerIndex)
		{
			if(CollisionCauser != PlayerIndex)
			{
				// CollisionCauser ist ein Schuss
				Objects[CollisionCauser].Status = 0; //Schuss lschen
				if(y == PlayerIndex)
				{
					cShips--;
					InvisibleTimer = 0x81;
				}
				else if(y > PlayerIndex)
					DestroySaucer();
				else
					SplitAsteroid(CollisionCauser, y);
				Objects[y].Status = -96;
				Objects[y].VelocityX = 0;
				Objects[y].VelocityY = 0;
				return y != PlayerIndex;
			}
			InvisibleTimer = 0x81;
			cShips--;
			CollisionCauser = PlayerIndex;
		}
		else if(y == PlayerIndex)
		{
			CollisionCauser = PlayerIndex;
			y = SaucerIndex;
			InvisibleTimer = 0x81;
			cShips--;
		}
		Objects[CollisionCauser].Status = -96;
		Objects[CollisionCauser].VelocityX = 0;
		Objects[CollisionCauser].VelocityY = 0;
		if(y < PlayerIndex)
		{
			SplitAsteroid(CollisionCauser, y);
		}
		else
		{
			assert(y == SaucerIndex);
			DestroySaucer();
		}
		Objects[y].Status = -96;
		Objects[y].VelocityX = 0;
		Objects[y].VelocityY = 0;
		return true;
	}


	void UpdateSaucer()//sub_6B93
	{return;
		if(FastTimer & 3 || Objects[SaucerIndex].Status < 0)
			return;
		
		if(Objects[SaucerIndex].Status == 0)
		{
			if(NumPlayers && Objects[PlayerIndex].Status <= 0)
				return;
			if(_2F9)
				_2F9--;
			if(--SaucerCountdown)
				return;
			SaucerCountdown = 0x12;
			if(_2F9 && (NumAsteroids == 0 || NumAsteroids >= _2FD))
				return;
			if(SaucerCountdownStart >= 38)
				SaucerCountdownStart -= 6;
			byte a = Rand();
			bool c;
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);
			ShiftRight(a, c);
			RotateRight(LowByte(Objects[SaucerIndex].PositionY), c);
			if(a >= 0x18)
				a &= 0x17;
			HighByte(Objects[SaucerIndex].PositionY) = a;
			Objects[SaucerIndex].PositionX = RandomSeed2 & 0x40 ? 0x1FFF : 0;
			Objects[SaucerIndex].VelocityX = RandomSeed2 & 0x40 ? -16 : 16;
			Objects[SaucerIndex].Status = 2;
			if(char(SaucerCountdownStart) >= 0 && (PlayerScoreThousends >= 0x30 || (SaucerCountdownStart>>1) >=  Rand()))
				Objects[SaucerIndex].Status = 1;
			return;
		}
		if((FastTimer << 1) == 0)
		{
			const char DirectionTable[] = {-16, 0, 0, 16};
			Objects[SaucerIndex].VelocityY = DirectionTable[Rand()&3];
		}
		if(NumPlayers && InvisibleTimer)
			return;
		if(--SaucerCountdown)
			return;
		SaucerCountdown = 0x0A;

		byte ShotDirection;
		if(Objects[SaucerIndex].Status != 2)
		{
			byte a = Objects[SaucerIndex].VelocityX;
			bool c = a >= 0x80;
			RotateRight(a, c);
			byte tmpC = a;
			a = LowByte(Objects[PlayerIndex].PositionX);
			c = true;
			Subtract(a, LowByte(Objects[SaucerIndex].PositionX), c);
			byte tmpB = a;
			a = HighByte(Objects[PlayerIndex].PositionX);
			Subtract(a, HighByte(Objects[SaucerIndex].PositionX), c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			c = true;
			Subtract(a, tmpC, c);
			byte x = a;

			a = Objects[SaucerIndex].VelocityY;
			c = a >= 0x80;
			RotateRight(a, c);
			tmpC = a;
			a = LowByte(Objects[PlayerIndex].PositionY);
			c = true;
			Subtract(a, LowByte(Objects[SaucerIndex].PositionY), c);
			tmpB = a;
			a = HighByte(Objects[PlayerIndex].PositionY);
			Subtract(a, HighByte(Objects[SaucerIndex].PositionY), c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			ShiftLeft(tmpB, c);
			RotateLeft(a, c);
			c = true;
			Subtract(a, tmpC, c);
			byte y = a;

			ShotDirection = loc_76F0(x, y);

			a = Rand();
			c = PlayerScoreThousends >= 0x35;
			a &= c ? 0x87 : 0x8F;
			if(char(a) < 0)
				a |= c ? 0x78 : 0x70;
			Add(ShotDirection, a, c);
		}
		else
			ShotDirection = Rand();

		int NewShot = SaucerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == SaucerShotMinIndex)
				return;

		Objects[NewShot] = Objects[SaucerIndex];
		Objects[NewShot].Status = ShotLifetime/4;

		ShootLocationFromAngle(ShotDirection, Objects[NewShot].PositionX, Objects[NewShot].PositionY, Objects[NewShot].VelocityX, Objects[NewShot].VelocityY);
	}

	byte loc_76F0(byte x, byte y)
	{
		if(char(y) < 0)
			return (loc_76FC(x, (y^0xFF)+1) ^ 0xFF) + 1;
		else
			return loc_76FC(x, y);
	}
	byte loc_76FC(byte x, byte y)
	{
		if(char(x) < 0)
			return (sub_770E((x^0xFF)+1, y) ^ 0x80 ^ 0xFF) + 1;
		else
			return sub_770E(x, y);
	}
	byte sub_770E(byte x, byte y)
	{
		if(x == y)
			return 0x20;
		if(y < x)
			return sub_7728(y, x, false);
		else
			return ((sub_7728(x, y, true) - 0x40) ^ 0xFF) + 1;
	}
	byte sub_7728(byte a, byte tmpC, bool c)
	{
		byte tmpB = 0;
		for(int i = 0; i < 4; i++)
		{
			RotateLeft(tmpB, c);
			RotateLeft(a, c);
			if(a >= tmpC)
				a -= tmpC;
		}
		RotateLeft(tmpB, c);

		const byte _772F[0x10] = {0x00, 0x02, 0x05, 0x07, 0x0A, 0x0C, 0x0F, 0x11, 0x13, 0x15, 0x17, 0x19, 0x1A, 0x1C, 0x1D, 0x1F};
		return _772F[tmpB & 0x0F];
	}

	void DestroySaucer()//loc_6B73
	{
		SaucerCountdown = SaucerCountdownStart;
		if(NumPlayers)
		{
			if(Objects[SaucerIndex].Status == 1)
				AddScore(100);
			else
				AddScore(20);
		}
	}

	byte Rand()
	{
		bool carry = false;
		ShiftLeft(RandomSeed1, carry);
		if(char(RotateLeft(RandomSeed2, carry)) < 0)
			RandomSeed1++;
		if(RandomSeed1 & 2)
			RandomSeed1 ^= 1;
		if((RandomSeed1|RandomSeed2) == 0)
			RandomSeed1++;
		return RandomSeed1;
	}
};

struct FramePacket
{
	char vectorram[1024];
	char frameno;  // wird bei jedem Frame inkrementiert
	char ping;     // Der Server schickt das letzte empfangene ping-byte zurck
	byte ram[0x300];
};

#pragma pack()


class Player
{
public:
	Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) {};
	void Run(void);
	void InterpretScreen(FramePacket &packet, GameStatus& game);
	void ReceivePacket(FramePacket &packet);
	void SendPacket(KeysPacket &packet);
private:
	SOCKET sd;
	ADDRESS server_ip;
};
